type formel = Formeltyp.formel =
  | Add of formel * formel
  | Sub of formel * formel
  | Mul of formel * formel
  | Div of formel * formel
  | Pot of formel * formel
  | Zahl of float
  | X
;;















let rec berechnen formel x =
  match formel with
    | Add (formel1, formel2) -> berechnen formel1 x  +.  berechnen formel2 x
    | Sub (formel1, formel2) -> berechnen formel1 x  -.  berechnen formel2 x
    | Mul (formel1, formel2) -> berechnen formel1 x  *.  berechnen formel2 x
    | Div (formel1, formel2) -> berechnen formel1 x  /.  berechnen formel2 x
    | Pot (formel1, formel2) -> berechnen formel1 x  **  berechnen formel2 x
    | Zahl z                 -> z
    | X                      -> x
;;














let rec ableiten formel =
  match formel with
    (* Regel: c' = 0   (c=konst.) *)
    | Zahl z -> Zahl 0.0

    (* Regel: x' = 1 *)
    | X -> Zahl 1.0

    (* Regel: ( f +- g )' = f' +-g' *)
    | Add (formel1, formel2) -> Add (ableiten formel1, ableiten formel2)
    | Sub (formel1, formel2) -> Sub (ableiten formel1, ableiten formel2)

    (* Regel: (c f)' = c f'  (c=konst.) *)
    | Mul (Zahl z, formel2) -> Mul (Zahl z, ableiten formel2)
    | Mul (formel1, Zahl z) -> Mul (ableiten formel1, Zahl z)

    (* Regel: (f g)' = f' g + f g' *)
    | Mul (formel1, formel2) ->
	Add (Mul(ableiten formel1, formel2), Mul(formel1, ableiten formel2))

    (* Regel: (f : c) = f' : c *)
    | Div (formel1, Zahl z) -> Div(ableiten formel1, Zahl z)

    (* Regel: (f : g)' = (f' g - f g') : g^2 *)
    | Div (formel1, formel2) -> 
	Div ( Sub ( Mul (ableiten formel1, formel2), 
		    Mul (formel1, ableiten formel2) ),
	      Pot ( formel2, Zahl 2.0 )
	    )

    (* Regel: (x^c)' = c x^(c-1) *)
    | Pot ( X, Zahl z ) -> Mul(Zahl z, Pot(X, Zahl (z -. 1.0)))

    (* Kettenregel fr Pot *)
    | Pot (formel1, Zahl z) ->
	Mul ( ersetzen (ableiten ( Pot (X, Zahl z) ) ) formel1,
	      ableiten formel1 
	    )

    (* Ggf. kann man bei Pot noch ausrechnen: *)
    | Pot (formel1, formel2) when not (enthaelt_X formel2) ->
	ableiten(Pot(formel1, Zahl (berechnen formel2 0.0)))

    (* Andere Pot-Flle gehen nicht (Logarithmus wrde bentigt) *)
    | _ ->
	failwith "Formel zu kompliziert"

and ersetzen formel formel_fuer_X =
  match formel with
    | Zahl z -> Zahl z
    | X -> formel_fuer_X
    | Add(formel1, formel2) -> Add(ersetzen formel1 formel_fuer_X,
				   ersetzen formel2 formel_fuer_X)
    | Sub(formel1, formel2) -> Sub(ersetzen formel1 formel_fuer_X,
				   ersetzen formel2 formel_fuer_X)
    | Mul(formel1, formel2) -> Mul(ersetzen formel1 formel_fuer_X,
				   ersetzen formel2 formel_fuer_X)
    | Div(formel1, formel2) -> Div(ersetzen formel1 formel_fuer_X,
				   ersetzen formel2 formel_fuer_X)
    | Pot(formel1, formel2) -> Pot(ersetzen formel1 formel_fuer_X,
				   ersetzen formel2 formel_fuer_X)

and enthaelt_X formel =
  match formel with
    | Zahl _ -> false
    | X -> true
    | Add(formel1, formel2) -> enthaelt_X formel1 || enthaelt_X formel2
    | Sub(formel1, formel2) -> enthaelt_X formel1 || enthaelt_X formel2
    | Div(formel1, formel2) -> enthaelt_X formel1 || enthaelt_X formel2
    | Mul(formel1, formel2) -> enthaelt_X formel1 || enthaelt_X formel2
    | Pot(formel1, formel2) -> enthaelt_X formel1 || enthaelt_X formel2
;;
