open Printf

type klammerausdruck =
    { symbol : string;
      bindungsstrke : int;
      unterausdrcke : klammerausdruck list;
    }


let rec string_von_klammerausdruck ka =
  match ka.unterausdrcke with
    | [] -> ka.symbol
    | [ka'] -> 
	string_von_klammerausdruck_ggf_mit_klammern 
	  (ka'.bindungsstrke <= ka.bindungsstrke)
	  ka'
	^ ka.symbol
    | ka_liste ->
	let str_liste =
	  List.map
	    (fun ka' ->
	       string_von_klammerausdruck_ggf_mit_klammern 
		 (ka'.bindungsstrke <= ka.bindungsstrke)
		 ka'
	    )
	    ka_liste in
	String.concat ka.symbol str_liste

and string_von_klammerausdruck_ggf_mit_klammern bedingung ka =
  if bedingung then
    "(" ^ string_von_klammerausdruck ka ^ ")"
  else
    string_von_klammerausdruck ka
;;

	
let rec klammerausdruck_von_formel formel =
  match formel with
    | Zahl z ->
	{ symbol = sprintf "%g" z; bindungsstrke = 10; unterausdrcke = [] }
    | X ->
	{ symbol = "x"; bindungsstrke = 10; unterausdrcke = [] }
    | Add (Add (formel1, formel2), formel3) ->
	klammerausdruck_von_formel (Add (formel1, Add(formel2, formel3)))
    | Add (formel1, (Add(formel2a, formel2b) as formel2)) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	let ka2 = klammerausdruck_von_formel formel2 in
	{ ka2 with unterausdrcke = ka1 :: ka2.unterausdrcke }
    | Add (formel1, formel2) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	let ka2 = klammerausdruck_von_formel formel2 in
	{ symbol = " + "; bindungsstrke = 0; unterausdrcke = [ka1; ka2] }
    | Sub (Sub (formel1a, formel1b) as formel1, formel2) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	let ka2 = klammerausdruck_von_formel formel2 in
	{ ka1 with unterausdrcke = ka1.unterausdrcke @ [ka2] }
    | Sub (formel1, formel2) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	let ka2 = klammerausdruck_von_formel formel2 in
	{ symbol = " - "; bindungsstrke = 0; unterausdrcke = [ka1; ka2] }
    | Mul (Mul(formel1, formel2), formel3) ->
	klammerausdruck_von_formel (Mul (formel1, Mul(formel2, formel3)))
    | Mul (formel1, (Mul(formel2a, formel2b) as formel2)) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	let ka2 = klammerausdruck_von_formel formel2 in
	{ ka2 with unterausdrcke = ka1 :: ka2.unterausdrcke }
    | Mul (formel1, formel2) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	let ka2 = klammerausdruck_von_formel formel2 in
	{ symbol = " "; bindungsstrke = 1; unterausdrcke = [ka1; ka2] }
    | Div (Div (formel1a, formel1b) as formel1, formel2) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	let ka2 = klammerausdruck_von_formel formel2 in
	{ ka1 with unterausdrcke = ka1.unterausdrcke @ [ka2] }
    | Div (formel1, formel2) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	let ka2 = klammerausdruck_von_formel formel2 in
	{ symbol = " : "; bindungsstrke = 1; unterausdrcke = [ka1; ka2] }
    | Pot (formel1, Zahl 1.0) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	{ symbol = ""; bindungsstrke = 2; unterausdrcke = [ ka1 ] }
    | Pot (formel1, Zahl 2.0) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	{ symbol = ""; bindungsstrke = 2; unterausdrcke = [ ka1 ] }
    | Pot (formel1, Zahl 3.0) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	{ symbol = ""; bindungsstrke = 2; unterausdrcke = [ ka1 ] }
    | Pot (formel1, formel2) ->
	let ka1 = klammerausdruck_von_formel formel1 in
	let ka2 = klammerausdruck_von_formel formel2 in
	{ symbol = " ^ "; bindungsstrke = 3; unterausdrcke = [ka1; ka2] }
;;


let print_formel fmt formel =
  Format.fprintf fmt "<:formel< %s >>" 
    (string_von_klammerausdruck
       (klammerausdruck_von_formel formel))
;;

#install_printer print_formel;;
