let fehlertolerant f x =
  try 
    let y = f x in
    match classify_float y with
      | FP_infinite
      | FP_nan ->
	  None
      | _ -> Some y
  with error -> None
;;


let rec y_min_max f xmin xschritt n =
  let y_opt = fehlertolerant f xmin in
  if n = 1 then
    match y_opt with
      | Some y -> Some (y, y)
      | None   -> None
  else
    let y_min_max_opt' = y_min_max f (xmin +. xschritt) xschritt (n-1) in
    match (y_opt, y_min_max_opt') with
      | (None, None) -> None
      | (Some y, None) -> Some (y, y)
      | (None, Some y_min_max') -> Some y_min_max'
      | (Some y, Some (y_min, y_max)) -> Some (min y y_min, max y y_max)
;;


let x_gre = 300 
let y_gre = 300 

let x_versatz = 10 
let y_versatz = 10

let x_gre_wirklich = x_gre - 2*x_versatz 
let y_gre_wirklich = y_gre - 2*y_versatz 

let graph_da = ref false

let plot_overlay f xmin xmax ymin ymax lschen =
  let xschritt = (xmax -. xmin) /. (float x_gre_wirklich) in
  let yschritt = (ymax -. ymin) /. (float y_gre_wirklich) in

  let x_von_screen xs =
    xmin +. float (xs - x_versatz) *. xschritt in

  let x_nach_screen x =
    int_of_float ((x -. xmin) /. xschritt) + x_versatz in

  let y_nach_screen y =
    int_of_float ((y -. ymin) /. yschritt) + y_versatz in
  
  if not !graph_da then 
    Graphics.open_graph (Printf.sprintf " %dx%d" x_gre y_gre);
  graph_da := true;

  if lschen then
    Graphics.clear_graph();

  let xs_org = x_nach_screen 0.0 in
  let ys_org = y_nach_screen 0.0 in

  Graphics.set_line_width 1;
  Graphics.moveto xs_org 0;
  Graphics.lineto xs_org (y_gre - 1);
  Graphics.moveto 0 ys_org;
  Graphics.lineto (x_gre - 1) ys_org;

  let xs_m1 = x_nach_screen (-1.0) in
  let xs_p1 = x_nach_screen 1.0 in
  let ys_m1 = y_nach_screen (-1.0) in
  let ys_p1 = y_nach_screen 1.0 in

  Graphics.set_color Graphics.blue;
  Graphics.moveto xs_m1 (ys_org - 5);
  Graphics.lineto xs_m1 (ys_org + 5);
  Graphics.moveto xs_p1 (ys_org - 5);
  Graphics.lineto xs_p1 (ys_org + 5);
  Graphics.moveto (xs_org - 5) ys_m1;
  Graphics.lineto (xs_org + 5) ys_m1;
  Graphics.moveto (xs_org - 5) ys_p1;
  Graphics.lineto (xs_org + 5) ys_p1;

  Graphics.set_color Graphics.black;
  Graphics.set_line_width 5;

  let position_ist_definiert = ref true in

  let x0 = x_von_screen 0 in
  ( match fehlertolerant f x0 with
      | None -> position_ist_definiert:= false
      | Some y0 ->
	  Graphics.moveto 0 (y_nach_screen y0)
  );

  for xs = 1 to x_gre - 1 do
    let x = x_von_screen xs in
    match fehlertolerant f x with
      | None ->
	   position_ist_definiert := false
      | Some y ->
	  if !position_ist_definiert then
	    Graphics.lineto xs (y_nach_screen y)
	  else (
	    Graphics.moveto xs (y_nach_screen y);
	    position_ist_definiert := true
	  )
  done
;;


let plot f xmin xmax =
  let xschritt = (xmax -. xmin) /. (float x_gre_wirklich) in
  let (ymin, ymax) = 
    match y_min_max f xmin xschritt x_gre_wirklich with
      | None -> failwith "plot: Funktion ist nirgendwo definiert"
      | Some (y_min, y_max) -> (y_min, y_max) in
  plot_overlay f xmin xmax ymin ymax true
;;


let plot2 f1 f2 xmin xmax =
  let xschritt = (xmax -. xmin) /. (float x_gre_wirklich) in
  let (ymin, ymax) = 
    match y_min_max f1 xmin xschritt x_gre_wirklich with
      | None -> failwith "plot: Funktion ist nirgendwo definiert"
      | Some (y_min, y_max) -> (y_min, y_max) in
  plot_overlay f1 xmin xmax ymin ymax true;
  plot_overlay f2 xmin xmax ymin ymax false;
;;


Sys.set_signal Sys.sigpipe Sys.Signal_ignore;;
